/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.Cache;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheFullException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.CacheObjectOutputStream;
import oracle.ias.cache.DiskMessage;
import oracle.ias.cache.LoadConflictException;
import oracle.ias.cache.LockMessage;
import oracle.ias.cache.Message;
import oracle.ias.cache.NetworkException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.Response;
import oracle.ias.cache.SSLConfigurator;
import oracle.ias.cache.Task;
import oracle.ias.cache.ThreadPool;
import oracle.ias.cache.UpdateMessage;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.Channel;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupConfig;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.ReplyInfo;
import oracle.ias.cache.group.SSLConfig;
import oracle.ias.cache.group.View;

class Net {
    static final String cbName = "Cache callback";
    static Channel chan;
    static int viewId;

    Net() {
    }

    static int init(GroupConfig groupConfig, boolean bl, String string) throws NetworkException {
        try {
            try {
                if (bl) {
                    Properties properties = System.getProperties();
                    String string2 = properties.getProperty("oracle.ias.cache.ssl.provider", "com.sun.net.ssl.internal.ssl.Provider");
                    String string3 = properties.getProperty("oracle.ias.cache.ssl.protocol", "TLS");
                    String string4 = properties.getProperty("oracle.ias.cache.ssl.algorithm", "SunX509");
                    String string5 = properties.getProperty("oracle.ias.cache.ssl.keyStore.type", "JKS");
                    HashMap hashMap = SSLConfigurator.list(string, true);
                    String string6 = (String)hashMap.get(SSLConfigurator.KEYSTORE);
                    String string7 = (String)hashMap.get(SSLConfigurator.PASSWORD);
                    if (string6 == null || string7 == null) {
                        throw new NetworkException(CacheInternal.EXP_INVALID_SSLCONF);
                    }
                    SSLConfig sSLConfig = new SSLConfig(string2, string3, string4, string5, string7, new FileInputStream(string6));
                    groupConfig.setSSLEnabled(true);
                    groupConfig.setSSLConfig(sSLConfig);
                }
            }
            catch (Exception exception) {
                throw new NetworkException(exception.toString(), exception);
            }
            GroupCommunication.init(false, groupConfig);
            chan = new Channel();
            chan.connect("Cache");
            chan.registerReceivingQueue(CacheInternal.asyncTaskQ);
            return chan.getGlobalPosition();
        }
        catch (GroupException groupException) {
            throw Net.exceptionHandler(groupException);
        }
    }

    static String getOriginalListenerName(Vector vector) {
        String string = null;
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        Address address = null;
        for (int i = 0; i < n; ++i) {
            address = (Address)vector.elementAt(i);
            if (address == null || !address.isOriginal()) continue;
            string = address.getHostName();
            break;
        }
        return string;
    }

    static String getLocalAddress() throws NetworkException {
        Address address;
        String string = null;
        if (chan != null && (address = (Address)chan.getLocalAddress()) != null) {
            string = address.getString();
        }
        return string;
    }

    static Address getLocalAddressObject() throws NetworkException {
        Address address = null;
        if (chan != null) {
            address = (Address)chan.getLocalAddress();
        }
        return address;
    }

    static void close() {
        try {
            if (chan != null) {
                chan.close();
            }
            GroupCommunication.term();
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Net] ", exception);
        }
    }

    private static void broadcast(Task task, CacheHandle cacheHandle, int n, boolean bl) throws NetworkException {
        long l = 0L;
        Object object = null;
        BitMap bitMap = null;
        Response response = null;
        Message message = (Message)task.info;
        if (message instanceof UpdateMessage) {
            object = ((UpdateMessage)message).updateObj;
        }
        if (CacheInternal.logger.shouldLog(7)) {
            CacheInternal.logger.log("[Net] broadcast " + task.getName() + ", nodeOnly=" + bl);
        }
        try {
            if (object != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
                CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(object);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                l = byArray.length;
                ((UpdateMessage)message).updateObj = byArray;
            }
            if (message.respond) {
                boolean bl2 = task.session;
                response = CacheInternal.respQ.getRespSlot(bl2);
                response.status = 0;
                cacheHandle.resp = response;
                message.messageId = ((long)response.id << 32) + (long)response.version;
            } else {
                message.messageId = 0L;
            }
            ReplyInfo replyInfo = bl ? chan.nodecast(task) : chan.multicast((Serializable)task, n, l);
            if (message.respond) {
                bitMap = replyInfo.getBitMap();
                bitMap.clearBit(CacheInternal.cacheId);
                if (bitMap.isZero()) {
                    response.status = 1;
                }
                CacheInternal.respQ.setParticipants(message.messageId, bitMap, replyInfo.viewId);
            }
        }
        catch (Exception exception) {
            throw Net.exceptionHandler(exception);
        }
    }

    static void broadcast(Task task, CacheHandle cacheHandle, int n) throws NetworkException {
        Net.broadcast(task, cacheHandle, n, false);
    }

    static void nodecast(Task task, CacheHandle cacheHandle) throws NetworkException {
        Net.broadcast(task, cacheHandle, 0, true);
    }

    static void send(Task task, Object object, Address address, CacheHandle cacheHandle) throws NetworkException {
        BitMap bitMap = null;
        Response response = null;
        Message message = (Message)task.info;
        Object var9_7 = null;
        try {
            if (address != null) {
                if (message.respond) {
                    boolean bl = true;
                    response = CacheInternal.respQ.getRespSlot(bl);
                    response.status = 0;
                    cacheHandle.resp = response;
                    message.messageId = ((long)response.id << 32) + (long)response.version;
                    View view = chan.getView();
                    bitMap = view.getBitMap();
                    for (int i = 0; i < bitMap.getCapacity(); ++i) {
                        bitMap.clearBit(i);
                    }
                    bitMap.setBit(address.getPosition());
                    if (bitMap.isZero()) {
                        response.status = 1;
                    }
                    CacheInternal.respQ.setParticipants(message.messageId, bitMap, view.getVid());
                } else {
                    message.messageId = 0L;
                }
            }
            Net.memSend(address, task, object);
        }
        catch (Exception exception) {
            throw Net.exceptionHandler(exception);
        }
    }

    static void memSend(Address address, Task task, Object object) throws NetworkException {
        long l = 0L;
        if (!GroupCommunication.isReady()) {
            return;
        }
        if (CacheInternal.logger.shouldLog(15)) {
            CacheInternal.logger.log("[Net] memSend " + task + ", " + object + ", to " + address);
        } else if (CacheInternal.logger.shouldLog(10)) {
            CacheInternal.logger.log("[Net] memSend " + task.getName() + ", to " + address);
        }
        try {
            if (object != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
                CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(object);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                l = byArray.length;
                UpdateMessage updateMessage = (UpdateMessage)task.info;
                updateMessage.updateObj = byArray;
            }
            chan.send((Object)address, (Serializable)task, l);
        }
        catch (Exception exception) {
            throw Net.exceptionHandler(exception);
        }
    }

    static void diskSend(Task task, long l, String string) {
        if (!GroupCommunication.isReady()) {
            return;
        }
        if (CacheInternal.logger.shouldLog(7)) {
            CacheInternal.logger.log("[Net] diskSend " + task + " fileName= " + string);
        }
        try {
            chan.send(task.replyAddr, (Serializable)task, l, string);
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Net] ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void receive(Task var0) {
        var1_1 = 1;
        var2_2 = null;
        var3_3 = null;
        var4_4 = (Message)var0.info;
        var5_5 = null;
        var6_6 = null;
        var11_7 = false;
        var12_8 = null;
        if (CacheInternal.logger.shouldLog(15)) {
            CacheInternal.logger.log("[Net] receive: " + var0);
        } else if (CacheInternal.logger.shouldLog(7)) {
            CacheInternal.logger.log("[Net] receive: " + var0.getName());
        }
        try {
            var6_6 = CacheHandleQ.getHandle();
            if (var4_4 instanceof UpdateMessage) {
                ((UpdateMessage)var4_4).setSerialized();
                var5_5 = (UpdateMessage)var4_4;
            }
            switch (var0.taskType) {
                case 1: {
                    if (CacheInternal.respQ.record(var4_4.messageId, var4_4.senderId, (int)var4_4.objectType, var4_4.exception, var4_4.cacheName, var4_4.qualifier)) break;
                    CacheInternal.asyncTaskQ.putTask(var0);
                    ** break;
                }
                case 3: 
                case 20: {
                    try {
                        var6_6.updateRemote(var5_5, var0.taskType);
                    }
                    catch (Exception var13_9) {
                        if (var0.taskType != 20 && (var0.taskType != 3 || var13_9 instanceof ObjectNotFoundException || var13_9 instanceof CacheNotAvailableException || var13_9 instanceof LoadConflictException || var13_9 instanceof CacheFullException)) ** GOTO lbl34
                        CacheInternal.exceptionLog("[Net] ", var13_9);
                        var1_1 = 2;
                        var12_8 = var13_9;
                    }
lbl34:
                    // 3 sources

                    if (!var5_5.respond) break;
                    var8_15 = new Message(var4_4.name, var4_4.qualifier, var4_4.group, var4_4.objectType, false);
                    var8_15.update(CacheInternal.cacheId, var1_1, false);
                    var8_15.setException(var12_8);
                    var8_15.messageId = var5_5.messageId;
                    var9_19 = new Task(1, var8_15);
                    var9_19.replyAddr = var0.replyAddr;
                    Net.memSend((Address)var0.replyAddr, var9_19, null);
                    ** break;
                }
                case 2: {
                    try {
                        var6_6.remoteInvalidate(var4_4.name, var4_4.qualifier, var4_4.bool1, var4_4.objectType == 1L);
                    }
                    catch (Exception var13_10) {
                        CacheInternal.exceptionLog("[Net] ", var13_10);
                        var1_1 = 2;
                        var12_8 = var13_10;
                    }
                    if (!var4_4.respond) break;
                    var8_16 = new Message(var4_4.name, var4_4.qualifier, var4_4.group, var4_4.objectType, false);
                    var8_16.update(CacheInternal.cacheId, var1_1, false);
                    var8_16.messageId = var4_4.messageId;
                    var8_16.setException(var12_8);
                    var9_20 = new Task(1, var8_16);
                    var9_20.replyAddr = var0.replyAddr;
                    Net.memSend((Address)var0.replyAddr, var9_20, null);
                    ** break;
                }
                case 18: {
                    try {
                        var6_6.remoteEnable(var4_4.name, var4_4.qualifier, var4_4.objectType == 1L);
                    }
                    catch (Exception var13_11) {
                        CacheInternal.exceptionLog("[Net] ", var13_11);
                        var1_1 = 2;
                        var12_8 = var13_11;
                    }
                    break;
                }
                case 17: {
                    try {
                        var6_6.remoteDisable(var4_4.name, var4_4.qualifier, var4_4.objectType == 1L);
                    }
                    catch (Exception var13_12) {
                        CacheInternal.exceptionLog("[Net] ", var13_12);
                        var1_1 = 2;
                    }
                    break;
                }
                case 6: {
                    var10_28 = (DiskMessage)var0.info;
                    if (!CacheInternal.arrayEquals(CacheInternal.diskUid, (byte[])((Address)var0.replyAddr).getTag())) break;
                    var6_6.updateDisk(var10_28);
                    ** break;
                }
                case 14: {
                    var10_29 = (DiskMessage)var0.info;
                    if (CacheInternal.arrayEquals(CacheInternal.diskUid, (byte[])((Address)var0.replyAddr).getTag()) && var6_6.checkDiskRef(var10_29)) {
                        var2_2 = new Boolean(true);
                    }
                    var9_21 = Net.buildResponse(var0, false, 0L, 0L, 0L, null);
                    Net.memSend((Address)var0.replyAddr, var9_21, var2_2);
                    ** break;
                }
                case 21: {
                    var11_7 = true;
                }
                case 7: 
                case 22: {
                    var4_4 = (Message)var0.info;
                    for (var13_13 = 100; var13_13 > 0; --var13_13) {
                        if (var0.viewId <= Net.getVid() || Net.chan.hasReceivedAll(var0.receivedVector)) {
                            var3_3 = var6_6.remoteSearch(var4_4.name, var4_4.qualifier, var4_4.group, var0.taskType, var11_7);
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    if (var13_13 == 0 && CacheInternal.logger.shouldLog(3)) {
                        CacheInternal.logger.log("[Net] Have not received latest update yet,ignore the net search task=" + var0);
                    }
                    if (var3_3 != null) {
                        var9_22 = Net.buildResponse(var0, var0.taskType == 22, var3_3.objStatus.createTime, var3_3.ttlInterval, var3_3.idleTime, null);
                        var5_5 = (UpdateMessage)var9_22.info;
                        if ((var3_3.state & 4096L) != 0L) {
                            var5_5.setType(4096L);
                            Net.diskSend(var9_22, var3_3.objStatus.size, (String)var3_3.object);
                            ** break;
                        }
                        if ((var3_3.state & 0x2000000L) != 0L) {
                            var5_5.setType(0x2000000L);
                            Net.diskSend(var9_22, var3_3.objStatus.fileSize, var3_3.path + File.separator + var3_3.fileName);
                            ** break;
                        }
                        var5_5.setType(16384L);
                        try {
                            Net.memSend((Address)var0.replyAddr, var9_22, var3_3.object);
                        }
                        catch (Exception var14_30) {
                            var9_22 = Net.buildResponse(var0, false, 0L, 0L, 0L, var14_30);
                            Net.memSend((Address)var0.replyAddr, var9_22, null);
                            if (!CacheInternal.logger.shouldLog(6)) break;
                            CacheInternal.exceptionLog("[Net] ", var14_30);
                        }
                        break;
                    }
                    var9_23 = Net.buildResponse(var0, false, 0L, 0L, 0L, null);
                    Net.memSend((Address)var0.replyAddr, var9_23, null);
                    ** break;
                }
                case 8: {
                    if (var5_5.updateObj == null) {
                        if (CacheInternal.respQ.record(var5_5.messageId, var5_5.senderId, (int)var5_5.objectType, var5_5.exception, var5_5.cacheName, var5_5.qualifier)) break;
                        CacheInternal.asyncTaskQ.putTask(var0);
                        ** break;
                    }
                    CacheInternal.respQ.saveSearch(var5_5.messageId, var5_5);
                    ** break;
                }
                case 12: {
                    if (var5_5.updateObj != null) {
                        CacheInternal.respQ.saveSearchList(var5_5.messageId, var5_5.senderId, var5_5.updateObj, (int)var5_5.objectType);
                    }
                    if (CacheInternal.respQ.record(var5_5.messageId, var5_5.senderId, (int)var5_5.objectType, var5_5.exception, var5_5.cacheName, var5_5.qualifier)) break;
                    CacheInternal.asyncTaskQ.putTask(var0);
                    ** break;
                }
                case 9: {
                    var14_31 = (LockMessage)var4_4;
                    if (var0.self) {
                        CacheInternal.respQ.awaitOwnership(var14_31.messageId, var14_31.senderId, var0.self, (int)var14_31.objectType);
                        ** break;
                    }
                    var1_1 = var6_6.findOwner(var14_31.name, var14_31.qualifier, var14_31.group, var0, var14_31.lockName);
                    if (var1_1 == 3) break;
                    var8_17 = new Message(var4_4.name, var4_4.qualifier, var4_4.group, var4_4.objectType, false);
                    var8_17.update(CacheInternal.cacheId, var1_1, false);
                    var8_17.messageId = var4_4.messageId;
                    var9_24 = new Task(10, var8_17);
                    var9_24.replyAddr = var0.replyAddr;
                    Net.memSend((Address)var0.replyAddr, var9_24, null);
                    ** break;
                }
                case 10: {
                    var4_4 = (Message)var0.info;
                    if (CacheInternal.respQ.awaitOwnership(var4_4.messageId, var4_4.senderId, var0.self, (int)var4_4.objectType)) break;
                    CacheInternal.asyncTaskQ.putTask(var0);
                    ** break;
                }
                case 15: {
                    var4_4 = (Message)var0.info;
                    if (var4_4.name.equals("invalidate")) {
                        CacheInternal.globalInvalidate(false);
                    }
                    if (!var4_4.name.equals("destroy")) break;
                    CacheInternal.globalDestroy(false);
                    ** break;
                }
                case 19: {
                    var4_4 = (Message)var0.info;
                    var2_2 = var6_6.getGlobalDiskMap(var4_4);
                    var9_25 = Net.buildResponse(var0, true, 0L, 0L, 0L, null);
                    Net.memSend((Address)var0.replyAddr, var9_25, var2_2);
                    ** break;
                }
                case 13: {
                    var4_4 = (Message)var0.info;
                    if (var4_4.name.equals("listobj")) {
                        var2_2 = CacheInternal.dumpToString(var4_4.qualifier);
                    } else if (var4_4.name.equals("severity")) {
                        var2_2 = new String("Cache " + CacheInternal.cacheId + " at " + CacheInternal.cacheAddress + ", set logger severity" + ", old=" + CacheInternal.logger.getSeverity() + ", new=" + (int)var4_4.objectType);
                        Cache.setLogSeverity((int)var4_4.objectType);
                    } else if (var4_4.name.equals("netdump")) {
                        CacheInternal.dump();
                        var2_2 = new String("Cache " + CacheInternal.cacheId + " at " + CacheInternal.cacheAddress + ", dump finished. ");
                    } else if (var4_4.name.equals("groupdump")) {
                        GroupCommunication.dump();
                        var2_2 = new String("Cache " + CacheInternal.cacheId + " at " + CacheInternal.cacheAddress + ", group dump finished. ");
                    } else {
                        var2_2 = var4_4.name.equals("getconfig") != false ? (Object)CacheInternal.getConfig() : (Object)new String(CacheInternal.cacheId + " at " + CacheInternal.cacheAddress + ", unknown command: " + var4_4.name);
                    }
                    var9_26 = Net.buildResponse(var0, true, 0L, 0L, 0L, null);
                    Net.memSend((Address)var0.replyAddr, var9_26, var2_2);
                    ** break;
                }
                default: {
                    if (var4_4.respond) {
                        var8_18 = new Message(var4_4.name, var4_4.qualifier, var4_4.group, var4_4.objectType, false);
                        var8_18.update(CacheInternal.cacheId, 2, false);
                        var8_18.messageId = var4_4.messageId;
                        var9_27 = new Task(1, var8_18);
                        var9_27.replyAddr = var0.replyAddr;
                        Net.memSend((Address)var0.replyAddr, var9_27, null);
                    }
                    if (!CacheInternal.logger.shouldLog(3)) break;
                    CacheInternal.logger.log("[Net] ", new CacheException(CacheInternal.EXP_INTERNAL));
                    CacheInternal.logger.flush();
                    break;
                }
            }
        }
        catch (Exception var13_14) {
            CacheInternal.exceptionLog("[Net] ", var13_14);
            var16_33 = null;
            try {
                if (var6_6 == null) return;
                CacheHandleQ.releaseHandle(var6_6);
                return;
            }
            catch (Exception var17_36) {
                CacheInternal.exceptionLog("[Net] ", var17_36);
                return;
            }
        }
lbl216:
        // 17 sources

        var16_32 = null;
        ** GOTO lbl-1000
        {
            catch (Throwable var15_38) {
                var16_34 = null;
                ** try [egrp 7[TRYBLOCK] [9 : 2201->2214)] { 
lbl224:
                // 1 sources

                if (var6_6 == null) throw var15_38;
                CacheHandleQ.releaseHandle(var6_6);
                throw var15_38;
lbl227:
                // 1 sources

                catch (Exception var17_37) {
                    CacheInternal.exceptionLog("[Net] ", var17_37);
                }
                throw var15_38;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Exception var17_35) {}
            CacheInternal.exceptionLog("[Net] ", var17_35);
            return;
            if (var6_6 == null) return;
            CacheHandleQ.releaseHandle(var6_6);
            return;
        }
    }

    static Task buildResponse(Task task, boolean bl, long l, long l2, long l3, Exception exception) {
        Message message = (Message)task.info;
        UpdateMessage updateMessage = new UpdateMessage(message.name, message.qualifier, message.group, null, 0L, null, l, false);
        updateMessage.messageId = message.messageId;
        updateMessage.ttlInterval = l2;
        updateMessage.idleTime = l3;
        if (exception != null) {
            updateMessage.setException(exception);
        }
        updateMessage.update(CacheInternal.cacheId, 1, false);
        Task task2 = new Task(bl ? 12 : 8, updateMessage);
        task2.replyAddr = task.replyAddr;
        return task2;
    }

    static void resetView(View view, View view2) {
        BitMap bitMap = (BitMap)view.getBitMap().clone();
        bitMap.andMap(view2.getBitMap());
        CacheInternal.respQ.resetParticipants(bitMap, view2.getVid());
        if (CacheInternal.logger.shouldLog(10) && view2 != null) {
            CacheInternal.logger.log("[Net] resetView to " + view2.getVid() + ", new map:" + bitMap);
            CacheInternal.logger.flush();
        }
        bitMap = null;
        viewId = view2.getVid();
        if (CacheInternal.diskPath != null && CacheInternal.isDistributed() && CacheInternal.setDiskLeader(view, view2)) {
            Task task = new Task(16, null);
            CacheInternal.asyncTaskQ.putTask(task);
        }
        if (view2.size() > ThreadPool.getMaxThread()) {
            ThreadPool.setMaxThread(view2.size() * 3);
        }
    }

    private static NetworkException exceptionHandler(Exception exception) {
        if (exception instanceof NetworkException) {
            return (NetworkException)exception;
        }
        NetworkException networkException = new NetworkException(exception.toString(), exception);
        networkException.setLogged();
        return networkException;
    }

    static void send(Address address, Task task, CacheHandle cacheHandle) throws NetworkException {
        BitMap bitMap = null;
        Response response = null;
        Message message = (Message)task.info;
        Object var8_6 = null;
        if (CacheInternal.logger.shouldLog(15)) {
            CacheInternal.logger.log("[Net] send " + task + ", to " + address);
        }
        try {
            if (message.respond) {
                boolean bl = true;
                response = CacheInternal.respQ.getRespSlot(bl);
                response.status = 0;
                cacheHandle.resp = response;
                message.messageId = ((long)response.id << 32) + (long)response.version;
            } else {
                message.messageId = 0L;
            }
            chan.send(address, task);
            if (message.respond) {
                View view = chan.getView();
                bitMap = view.getBitMap();
                for (int i = 0; i < bitMap.getCapacity(); ++i) {
                    bitMap.clearBit(i);
                }
                bitMap.setBit(address.getPosition());
                if (bitMap.isZero()) {
                    response.status = 1;
                }
                CacheInternal.respQ.setParticipants(message.messageId, bitMap, view.getVid());
            }
        }
        catch (Exception exception) {
            throw Net.exceptionHandler(exception);
        }
    }

    static int getVid() {
        if (viewId == -1) {
            try {
                View view;
                if (chan != null && (view = chan.getView()) != null) {
                    viewId = view.getVid();
                }
            }
            catch (GroupException groupException) {
                CacheInternal.exceptionLog("[Net] ", groupException);
            }
        }
        return viewId;
    }

    static View getView() throws GroupException {
        View view = chan.getView();
        return view;
    }

    static long getUid() {
        return chan.getUid();
    }

    static long getTimeStamp() {
        return chan.getTimeStamp();
    }

    static boolean isAlive(long l, long l2) {
        return chan.isAlive(l, l2);
    }

    static {
        viewId = -1;
    }
}

